#include <iostream>
#include "Manager.h";
#include <string>
using namespace std;

//----------------------------------------------------------//
//---	add_subaltern - add worker to subalterns list	 ---//
//----------------------------------------------------------//
void Manager::add_subaltern(CorporatePerson* p_subaltern)
{
	mListalterns.push_back(p_subaltern);
}

//----------------------------------------------------------//
//--- remove_subaltern - add worker from subalterns list  --//
//----------------------------------------------------------//
void Manager::remove_subaltern(CorporatePerson* p_subaltern)
{
	mListalterns.remove(p_subaltern);
}


//-----------------------------//
//--  print worker's data   ---//
//-----------------------------//
void Manager::print_data()
{
	CorporatePerson::print_data();
	for (list<CorporatePerson*>::iterator it=mListalterns.begin(); it!=mListalterns.end(); ++it)  // Go to any subalterns list
	{
    	(*it)->print_data();
	}
}

//----------------------------------------------------------//
//---	 GetSalary - get salary of all subalterns list   ---//
//----------------------------------------------------------//
int Manager::GetSalary()
{
	int salary = 0;
	salary = CorporatePerson::GetSalary();
	for (list<CorporatePerson*>::iterator it=mListalterns.begin(); it!=mListalterns.end(); ++it) // Go to any subalterns list
	{
    	salary = salary + (*it)->GetSalary();
	}
	return salary;
}

//------------------------------------------------------------------------------//
//---	 GetNumOfEmployees - get the num of workers of all subalterns list   ---//
//------------------------------------------------------------------------------//
int Manager::GetNumOfEmployees()
{
	int num = 0;
	num += mListalterns.size();
	for (list<CorporatePerson*>::iterator it=mListalterns.begin(); it!=mListalterns.end(); ++it)	// Go to any subalterns list
	{
		num = num + (*it)->GetNumOfEmployees();
	}
	NumOfEmployees = num;
	return NumOfEmployees;
}


//------------------------------------------------------------------------------//
//---  	 AvaregeSalary - get the average salary of all subalterns list       ---//
//------------------------------------------------------------------------------//
double Manager::AvaregeSalary()
{
	int sum = GetSalary();
	NumOfEmployees = GetNumOfEmployees() + 1; //add the manager to average
	double average = sum/NumOfEmployees; 
	return average;
}

//---------------------//
//---	  d'tor	    ---//
//---------------------//
Manager::~Manager()
{
	for (list<CorporatePerson*>::iterator it=mListalterns.begin(); it!=mListalterns.end(); ++it)
	{
    	mListalterns.erase(it);	// erase
	}
}

